(function () {
    'use strict';

    const style = document.createElement('style');
    style.textContent = `
        /* 通用模态窗口样式 */
        .appstack-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.4);
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        .appstack-modal-content {
            background-color: #fefefe;
            margin: 10% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 600px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            position: relative;
        }
        .appstack-close-btn {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .appstack-close-btn:hover,
        .appstack-close-btn:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        .appstack-modal h2 {
            margin-top: 0;
            color: #333;
            font-size: 18px;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        .appstack-form-group {
            margin-bottom: 15px;
        }
        .appstack-modal label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: #555;
        }
        .appstack-modal select, .appstack-modal input[type="number"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        .appstack-changes-list {
            list-style: none;
            padding: 0;
            max-height: 200px;
            overflow-y: auto;
            border: 1px solid #eee;
            border-radius: 4px;
        }
        .appstack-changes-list li {
            padding: 8px 10px;
            border-bottom: 1px solid #f5f5f5;
            display: flex;
            align-items: center;
        }
        .appstack-changes-list li:last-child {
            border-bottom: none;
        }
        .appstack-changes-list input[type="checkbox"] {
            margin-right: 10px;
        }
        .appstack-deploy-btn {
            background-color: #1890ff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            width: 100%;
            margin-top: 10px;
        }
        .appstack-deploy-btn:hover {
            background-color: #40a9ff;
        }
        .appstack-deploy-btn:disabled {
            background-color: #d9d9d9;
            cursor: not-allowed;
        }
        .appstack-log-container {
            margin-top: 15px;
            background: #f5f5f5;
            padding: 10px;
            border-radius: 4px;
            max-height: 150px;
            overflow-y: auto;
            font-size: 12px;
            font-family: monospace;
        }
        .appstack-log-item {
            margin-bottom: 4px;
            border-bottom: 1px dashed #e8e8e8;
            padding-bottom: 2px;
        }
        .appstack-log-success { color: green; }
        .appstack-log-error { color: red; }
        .appstack-log-info { color: #666; }

        /* 打赏功能样式 */
        .appstack-donate-trigger {
            position: absolute;
            bottom: 20px;
            right: 20px;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 24px;
            margin: 0;
            padding: 0;
            z-index: 10;
            animation: appstack-pulse 2s infinite;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        .appstack-donate-trigger:hover {
            opacity: 1;
        }
        @keyframes appstack-pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.2); }
            100% { transform: scale(1); }
        }
        .appstack-donate-modal-content {
            width: 360px;
            text-align: center;
        }
        .appstack-qr-tabs {
            margin: 20px 0;
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .appstack-qr-btn {
            padding: 6px 16px;
            border: 1px solid #d9d9d9;
            background: #fff;
            cursor: pointer;
            border-radius: 4px;
            font-size: 14px;
            transition: all 0.3s;
        }
        .appstack-qr-btn:hover {
            color: #40a9ff;
            border-color: #40a9ff;
        }
        .appstack-qr-btn.active {
            background: #1890ff;
            color: white;
            border-color: #1890ff;
        }
        .appstack-qr-img {
            width: 200px;
            height: 200px;
            object-fit: contain;
            border: 1px solid #f0f0f0;
            border-radius: 4px;
            padding: 4px;
            margin-bottom: 10px;
        }
        .appstack-author-email {
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px dashed #e8e8e8;
            color: #8c8c8c;
            font-size: 12px;
        }
    `;
    document.head.appendChild(style);
})();
